/*
 * File: FunWithText.java
 * ================================================================
 * A program where we have fun with text!
 */
import acm.program.*;

public class FunWithText extends ConsoleProgram {
	/* Pause time between characters. */
	private static final double PAUSE_TIME = 75;
	
	/**
	 * Prints the given string character by character with
	 * a slight pause in-between.
	 * 
	 * @param text The text to print.
	 */
	private void printCharByChar(String text) {
		/* Visit each character one at a time, printing each one out. */
		for (int i = 0; i < text.length(); i++) {
			print(text.charAt(i));
			pause(PAUSE_TIME);
		}
		
		/* Print a newline at the end. */
		print('\n');
	}
	
	/**
	 * Returns whether the given text string could be a word.  Words aren't
	 * empty and consist solely of letters.
	 * 
	 * @param text The text to check.
	 * @return Whether it's a word.
	 */
	private boolean isWord(String text) {
		/* If the string is empty, it's not a word. */
		if (text.length() == 0) {
			return false;
		}
		
		/* Check whether each character is a letter. */
		for (int i = 0; i < text.length(); i++) {
			char currChar = text.charAt(i);
			
			if (!Character.isLetter(currChar)) {
				return false;
			}
		}
		
		return true;
	}
	
	/**
	 * Reads a word from the user and returns it.
	 * @param prompt The prompt for the word.
	 * @return The word the user entered.
	 */
	private String readWord(String prompt) {
		while (true) {
			/* Grab text from the user.  If it's a word, return it. */
			String text = readLine(prompt);
			if (isWord(text)) {
				return text;
			}
			
			println("Sorry, but that isn't a word.");
		}
	}
	
	/**
	 * Given a string, returns a new string that is the reverse of the original string.
	 * 
	 * @param text The string to reverse
	 * @return The reverse of that string.
	 */
	private String reverseString(String text) {
		/* Build up a new string from scratch. */
		String result = "";
		
		/* One option, which we discussed first, is to repeatedly prepend
		 * characters to the front of the result string.  Note that in
		 * each iteration, a new string is formed.
		 * 
		 * for (int i = 0; i < text.length(); i++) {
		 *    result = text.charAt(i) + result;
		 * }
		 */
		
		/* The other option is to append the characters in reverse order
		 * to our resulting string.
		 */
		for (int i = text.length() - 1; i >= 0; i--) {
			result += text.charAt(i);
		}
		
		return result;
	}
	
	/**
	 * Given a string, returns a new string formed by stripping out all non-letter
	 * characters from the original string.
	 * 
	 * @param text The string to process.
	 * @return The input string, but with all non-letters removed.
	 */
	private String stripOutNonLetters(String text) {
		/* Again, we build up the result one at a time. */
		String result = "";
		
		/* Add in each character if it's a letter. */
		for (int i = 0; i < text.length(); i++) {
			if (Character.isLetter(text.charAt(i))) {
				result += text.charAt(i);
			}
		}
		
		return result;
	}
	
	/**
	 * Returns whether the given string is a palindrome.  Palindromes are strings
	 * that are the same forwards and backwards.
	 * 
	 * @param text The string to check.
	 * @return Whether it's a palindrome.
	 */
	private boolean isPalindrome(String text) {
		/* To ensure that we don't compare upper and lower case letters,
		 * make everything lowercase.
		 */
		text = text.toLowerCase();
		
		/* Remove all non-letter characters from the string.  We don't want
		 * those to count against us.
		 */
		text = stripOutNonLetters(text);
		
		/* Check if the string is now the same forwards and backwards. */
		return text.equals(reverseString(text));
	}
	
	/**
	 * Reads in a string from the user representing their favorite animal,
	 * reprompting them until they answer correctly.
	 * 
	 * @return The user's favorite animal.
	 */
	private String readFavoriteAnimal() {
		while (true) {
			String line = readLine("Enter your favorite animal: ");
			
			/* Check if "ibex" appears anywhere in the string.  Note the
			 * call to toLowerCase to ensure that we test whether the lower-case
			 * version of the input string contains "ibex."
			 */
			if (line.toLowerCase().indexOf("ibex") != -1)
				return line;
			
			println("That's not a good choice.");
		}
	}
	
	/**
	 * Replaces the first instance of the given pattern string with the given
	 * replacement string.
	 * 
	 * @param text The text in which the replacement should be performed.
	 * @param toReplace The string that should be replaced.
	 * @param toReplaceWith What it should be replaced with.
	 * @return The string, with the appropriate substitution made.
	 */
	private String replaceInString(String text,
			                       String toReplace,
			                       String toReplaceWith) {
		/* Determine where, if anywhere, the replacement string is.  If it isn't
		 * present, hand back the original string unchanged.
		 */
		int index = text.indexOf(toReplace);
		if (index == -1)
			return text;
		
		/* Otherwise, break the string into the region before and after the string
		 * to replace, then splice in the replacement string.
		 */
		return text.substring(0, index) +
			   toReplaceWith +
			   text.substring(index + toReplace.length());
	}
	
	public void run() {
		/* We're working with text!  We should be big and bold! */
		setFont("DejaVuSerif-BOLD-32");
		
		String result = "Giants won 21-17";
		result = replaceInString(result, "Giants", "Karel the Robot");
		
		println(result);
	}
}